#version 150

#moj_import <fog.glsl>

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform float GameTime;
uniform vec4 FogColor;

uniform vec2 ScreenSize;

//191a24
uniform vec4 RainbowColor = vec4(25, 26, 36, 1.0);
//061a0b
uniform vec4 BouncyColor = vec4(6, 26, 11, 1.0);

in float vertexDistance;
in vec4 vertexColor;
in vec2 texCoord0;
in vec4 Color;

out vec4 fragColor;

bool isRed(vec4 a) {
    return a.r == 0.988235294 && a.g == 0.329411765 && a.b == 0.329411765 && a.a == 1.0;
}

bool compareColor(vec4 a, vec4 target) {
    return round(a.r * 255) == target.r
     && round(a.g * 255) == target.g
     && round(a.b * 255) == target.b
     ;
}

//generate modulo function
float modulate(float a, float b) {
    return a - b * floor(a / b);
}


void main() {
    vec4 color = texture(Sampler0, texCoord0) * vertexColor * ColorModulator;
    if (color.a < 0.1) discard;
    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);

    if (isRed(fragColor) && ScreenSize.x - gl_FragCoord.x < 52) {
        discard;
    } else if (compareColor(color, RainbowColor)) {
        vec4 c = vec4(0.0);
        // c.rgb = sin((vec3(0.,.33,.66) + c.rgb + (gl_FragCoord.x * modulate(GameTime, 2400) / 100) + modulate(GameTime, 2400) * 1200) * 6.28) * .5 + .5;
        c.rgb = sin((vec3(0.,.33,.66) + c.rgb + (gl_FragCoord.x * modulate(GameTime, 2400) / 100) + modulate(GameTime, 2400) * 1200) * 6.28) * .5 + .5;
        c.a = 1.0;
        fragColor = c;
    }
}
