#version 150

#moj_import <fog.glsl>

in vec3 Position;
in vec4 Color;
in vec2 UV0;
in ivec2 UV2;

//061a0b
uniform vec4 BouncyColor = vec4(6, 26, 11, 1.0);
uniform vec4 CatJamColor = vec4(255, 0, 0, 1.0);
uniform vec4 HalloweenColor = vec4(22, 8, 23, 1.0);

uniform sampler2D Sampler0;
uniform sampler2D Sampler2;

uniform mat4 ModelViewMat;
uniform mat4 ProjMat;
uniform mat3 IViewRotMat;
uniform float GameTime;

out float vertexDistance;
out vec4 vertexColor;
out vec2 texCoord0;

uniform vec2 ScreenSize;

bool compareColor(vec4 a, vec4 target) {
    return round(a.r * 255) == target.r
     && round(a.g * 255) == target.g
     && round(a.b * 255) == target.b
     ;
}

vec2 getPositionOfPixel(vec2 uv) {
    vec2 pos = vec2(0.0);
    pos.x = (uv.x * 2.0 - 1.0) * ScreenSize.x / 2.0;
    pos.y = (uv.y * 2.0 - 1.0) * ScreenSize.y / 2.0;
    return pos;
}

void main() {
    gl_Position = ProjMat * ModelViewMat * vec4(Position, 1.0);
    
    vertexDistance = length((ModelViewMat * vec4(Position, 1.0)).xyz);
    vertexColor = Color * texelFetch(Sampler2, UV2 / 16, 0);
    texCoord0 = UV0;

    vec4 verColor = vec4(vertexColor.rgb, 1.0);
    if (compareColor(verColor, BouncyColor)) {
        gl_Position.y -= abs(sin(radians(fract((GameTime + gl_Position.x * 2) * 500) * 360))) * .01 * sin(radians(fract(GameTime * 2400) * 360));
        vertexColor = vec4(1.0, 1.0, 1.0, 1.0);
    } else if (compareColor(verColor, HalloweenColor)) {
        vertexColor = vec4(0);
    } else if (compareColor(Color, vec4(181, 18, 18, 1.0))) {
        texCoord0 = UV0 / 3;
    }
}
